library(tcltk) 

# parameter of the geometric distribution 
p=0.5

# Maximum number of time steps 
N=10000 

A=array(10001);

A[1]=10

M=A[1]

m=0;m0=0;

split.screen(c(1,1)) 
 
for(l in seq(1:N))
{
if (A[l]>0) 
{ 
A[l+1]=0
for(lll in seq(1:A[l])) 
{ 
A[l+1]=A[l+1]+rgeom(1,1-p)
} 
}

if (A[l]==0) {A[l+1]=0;m=m+1}

print(l+1)
print(A[l+1])

if (A[l+1]==0 && A[l]>0) {alarm();m0=l}

# if (A[l+1]>0) {tkbell()}

if (A[l+1]>M) {M=A[l+1]}

screen(1,FALSE)

#tkbell()

par(bg = "white")

plot(0:l,A,type="o", xlim=c(0,max(100,l)),ylim=c(0,max(40,M)), xlab="", ylab="", yaxt="n",xaxt="n",xaxs="i",col="blue", main = "Branching process",bty="n")

axis(2,pos=0,at=seq(0,max(40,M),max(1,floor(max(40,M)/10))))

axis(1,pos=0,at=seq(0,max(100,l),max(1,floor(max(100,l)/10))),outer=TRUE)

Sys.sleep(0.4)
 
if (m>5+m0*0.2) {break} 

} 

dev.copy(png,'branching_rescaled.png')
dev.off()
